/*
 ͻ
 									    
   Source Code   :  PCX.H                                                  
                                                                           
   Description   :  Header For Miscellaneous PCX Functions                 
                                                                           
 ͼ

 ͻ
                 Prevent second reading of PCX definitions                 
 ͼ
*/

#ifndef	__PCX_H
#define	__PCX_H

/*
 ͻ
                      Preprocessor #include Directives                     
 ͼ
*/

#include "stdio.h"
#include "stdlib.h"

/*
 ͻ
                                  PCX Class                                
 ͼ
*/

class pcx_header
{
public:
  char manufacturer;    		// always 0xA0
  char version;         		// 5 for 256-colour
  char encoding;        		// always 1
  char bits_per_pixel;  		// 8 for 256-colour
  int  pcx_image_x_origin;		// image x origin - left corner
  int  pcx_image_y_origin;		// image y origin - top corner
  int  pcx_image_width;			// image width
  int  pcx_image_height;		// image height
  int  image_horizontal_resolution;    	// image horizontal resolution
  int  image_vertical_resolution;     	// image vertical resolution
  char ega_palette[48];   		// EGA palette not used
  char reserved;
  char colour_planes;    		// 1 colour plane in mode 0x13
  int  bytes_per_line;  		// 80 bytes per line
  int  palette_type;    		// 2 for colour palette
  char filler[58];      		// round header to 128 bytes
};

class pcx_class
{
public:
  pcx_header header;                	// class for holding the PCX header
  unsigned char far *pcx_image;     	// -> buffer holding 64k-byte bitmap
  unsigned char pcx_palette[256 * 3]; 	// array holding the 768-byte palette
};

class pcx
{
private:
  FILE *input_file;
  void load_image(FILE *pcx_file, pcx_class *pcx);        // PCX bitmap
  void load_palette(FILE *pcx_file, pcx_class *pcx);      // PCX palette
public:
  void load_pcx_file(char far *filename, pcx_class *pcx); // PCX data
};

/*
 ͻ
                               End of Header                               
 ͼ
*/

#endif						// ends #ifndef __PCX_H
